import assign from 'lodash/assign';
import { ACTION_SET_ADBLOCK_DETECTED, ACTION_SET_CLICKTHROUGH_URL, ACTION_SET_AD_METADATA,
         ACTION_IMA_SCRIPT_LOADED, ACTION_SET_VOD_MIDROLL_ARCHIVE_SETTING,
         AdContentTypes, AdRollTypes } from '../actions/ads';
import { ACTION_SET_STREAM } from '../actions/stream';
import { VOD_MIDROLL_SETTING_INSERTED } from '../vod-midroll-manager';

const DEFAULT_ADS = {
    currentMetadata: {
        contentType: AdContentTypes.NONE,
        rollType: AdRollTypes.NONE,
    },
    adblock: false,
    clickThrough: '',
    imaScriptLoaded: false,
    vodMidrollArchiveSetting: VOD_MIDROLL_SETTING_INSERTED,
};

/**
 * Store reducer for advertisement state.
 *
 * @param {?Object} adState
 * @param {Action} action
 * @return {Object}
 */
export function ads(adState = DEFAULT_ADS, action) {
    switch (action.type) {
    case ACTION_SET_ADBLOCK_DETECTED:
        return assign({}, adState, {
            adblock: action.detected,
        });
    case ACTION_SET_CLICKTHROUGH_URL:
        return assign({}, adState, {
            clickThrough: action.URL,
        });
    case ACTION_SET_AD_METADATA:
        if (action.currentMetadata.contentType === AdContentTypes.STITCHED) {
            return assign({}, adState, {
                currentMetadata: action.currentMetadata,
            });
        }

        return assign({}, adState, {
            currentMetadata: action.currentMetadata,
            clickThrough: DEFAULT_ADS.clickThrough,
        });
    case ACTION_IMA_SCRIPT_LOADED:
        return assign({}, adState, {
            imaScriptLoaded: action.imaScriptLoaded,
        });
    case ACTION_SET_VOD_MIDROLL_ARCHIVE_SETTING:
        return assign({}, adState, {
            vodMidrollArchiveSetting: action.setting,
        });
    case ACTION_SET_STREAM:
        return assign({}, adState, {
            vodMidrollArchiveSetting: VOD_MIDROLL_SETTING_INSERTED,
        });
    default:
        return adState;
    }
}
