import { ACTION_SET_ANALYTICS_TRACKER } from '../actions/analytics-tracker';

const ERROR_NO_TRACKER = new Error('Attempting to use tracker too early');
const DEFAULT_TRACKER = {
    trackEvent() {
        return Promise.reject(ERROR_NO_TRACKER);
    },
};

/**
 * Store reducer for analytics tracker.
 *
 * @param {Object} analytics tracker
 * @param {Action} action
 * @return {Object}
 */
export function analyticsTracker(currentTracker = DEFAULT_TRACKER, action) {
    switch (action.type) {
    case ACTION_SET_ANALYTICS_TRACKER:
        return action.tracker;
    default:
        return currentTracker;
    }
}
