import extend from 'lodash/extend';
import { ACTION_INCREMENT_QUALITY_CHANGE_COUNT,
         ACTION_RESET_QUALITY_CHANGE_COUNT,
         ACTION_RESET_PLAY_SESSION,
         ACTION_SET_TRACKING_CLIENTS } from '../actions/analytics';

export const DEFAULT_ANALYTICS = {
    qualityChangeCount: 0,
    // Populate on analytics tracker init.
    playSessionId: '',
    playSessionStartTime: 0,
    trackingClients: [],
};

/**
 * Store reducer for analytics.
 *
 * @param {Object} analytics
 * @param {Action} action
 * @return {Object}
 */
export function analytics(currentAnalytics = DEFAULT_ANALYTICS, action) {
    switch (action.type) {
    case ACTION_INCREMENT_QUALITY_CHANGE_COUNT:
        return extend({}, currentAnalytics, { qualityChangeCount: currentAnalytics.qualityChangeCount + 1 });
    case ACTION_RESET_QUALITY_CHANGE_COUNT:
        return extend({}, currentAnalytics, { qualityChangeCount: 0 });
    case ACTION_SET_TRACKING_CLIENTS:
        return extend({}, currentAnalytics, { trackingClients: action.clients });
    case ACTION_RESET_PLAY_SESSION:
        return extend({}, currentAnalytics, {
            playSessionId: action.playSessionId,
            playSessionStartTime: action.playSessionStartTime,
        });
    default:
        return currentAnalytics;
    }
}
