import assign from 'lodash/assign';
import { ACTION_SET_PLAYER_BACKEND_TYPE } from '../actions/backend-info';
import { BACKEND_BLANK_TYPE } from 'backend/blank';

const DEFAULT_BACKEND_INFO = {
    playerBackendType: BACKEND_BLANK_TYPE,
};

export function backendInfo(backendInfo = DEFAULT_BACKEND_INFO, action) {
    switch (action.type) {
    case ACTION_SET_PLAYER_BACKEND_TYPE:
        return assign({}, backendInfo, {
            playerBackendType: action.playerBackendType,
        });
    default:
        return backendInfo;
    }
}
