import { ACTION_SET_BACKEND } from '../actions/backend';
import { BackendBlank } from '../backend/blank';

/**
 * Store reducer for the playback backend
 *
 * @param {Object} backend
 * @param {Action} action
 * @return {Object}
 */
export function backend(backend = new BackendBlank(), action) {
    switch (action.type) {
    case ACTION_SET_BACKEND:
        return action.backend;
    default:
        return backend;
    }
}
