import {
    ACTION_BROADCASTER_INFO_LOADED,
    NOT_AVAILABLE,
} from 'actions/broadcaster-info';
import { addIfNotPresent } from 'ui/player-types/clips/utils/state-helper';
import assign from 'lodash/assign';

/**
 * --Example State Shape
 *
 *   broadcasterInfo: {
 *     byName: {
 *       ['monstercat']: {
 *           partnerStatus: BROADCASTER_IS_PARTNER,
 *           liveStatus: BROADCASTER_IS_LIVE,
 *           stream: {},
 *       },
 *       ['clintfm']: {
 *           partnerStatus: BROADCASTER_IS_NOT_PARTNER,
 *           liveStatus: BROADCASTER_IS_NOT_LIVE,
 *           stream: NOT_AVAILABLE,
 *       },
 *     },
 *     allNames: [
 *       'monstercat',
 *       'clintfm',
 *     ],
 *   }
 */
export const DEFAULT_BROADCASTER_INFO = {
    byName: {},
    allNames: [],
};

/**
 * Store reducer for broadcaster info
 *
 *
 * @param {Object} broadcasterInfo
 * @param {Action} action
 * @return {Object}
 */
export function broadcasterInfo(currentState = DEFAULT_BROADCASTER_INFO, action) {
    switch (action.type) {
    case ACTION_BROADCASTER_INFO_LOADED: {
        const newState = assign({}, currentState);

        newState.byName[action.channelName] = assign({},
            newState.byName[action.channelName] || {},
            action.info
        );

        newState.allNames = addIfNotPresent(newState.allNames, action.channelName);

        return newState;
    }
    default:
        return currentState;
    }
}

const getBroadcasterAttribute = (state, channelName, attribute) => {
    const stateBroadcasterInfo = state.broadcasterInfo.byName[channelName];

    return stateBroadcasterInfo && stateBroadcasterInfo[attribute] ?
        stateBroadcasterInfo[attribute] : NOT_AVAILABLE;
};

export const broadcasterLiveStatus = (state, channelName) => (
    getBroadcasterAttribute(state, channelName, 'liveStatus')
);
export const broadcasterPartnerStatus = (state, channelName) => (
    getBroadcasterAttribute(state, channelName, 'partnerStatus')
);
export const broadcasterStream = (state, channelName) => (
    getBroadcasterAttribute(state, channelName, 'stream')
);
