import extend from 'lodash/extend';
import { presetMap } from '../captions/captions-style-map';
import { ACTION_INITIALIZE_CAPTIONS_SETTINGS, ACTION_SET_CAPTIONS_DATA, ACTION_SET_CAPTIONS_PRESET,
         ACTION_TOGGLE_CAPTIONS, ACTION_SHOW_CC_MODAL } from '../actions/captions';
import { ACTION_SET_STREAM } from '../actions/stream';
import { ACTION_UPDATE_PLAYER_DIMENSIONS } from 'actions/player-dimensions';

export const DEFAULT_CAPTION = {
    enabled: false,
    available: false,
    preset: 'white-on-black',
    data: null,
    style: presetMap['white-on-black'],
    showCCModal: false,
};
export const CAPTIONS_AUTO_RESIZE_THRESHOLD_HEIGHT = 322;
export const CAPTIONS_AUTO_RESIZE_THRESHOLD_WIDTH = 500;
export const CAPTIONS_AUTO_RESIZE_SCALE = 0.05;

// eslint-disable-next-line complexity
export function captions(currentCaption = DEFAULT_CAPTION, action) {
    switch (action.type) {
    case ACTION_SHOW_CC_MODAL:
        return extend({}, currentCaption, { showCCModal: action.showCCModal });
    case ACTION_INITIALIZE_CAPTIONS_SETTINGS:
    case ACTION_SET_CAPTIONS_PRESET:
    case ACTION_TOGGLE_CAPTIONS:
        return extend({}, currentCaption, action.captions);
    case ACTION_SET_CAPTIONS_DATA:
        return extend({}, currentCaption, {
            data: action.captions.data,
            available: currentCaption.available || action.captions.data.data.length > 0,
        });
    case ACTION_SET_STREAM:
        return extend({}, currentCaption, {
            available: DEFAULT_CAPTION.available,
            data: DEFAULT_CAPTION.data,
        });
    // eslint-disable-next-line no-case-declarations
    case ACTION_UPDATE_PLAYER_DIMENSIONS:
        const currentHeight = action.playerDimensions.height;
        const currentWidth = action.playerDimensions.width;
        const shouldResizeCaptions = currentHeight <= CAPTIONS_AUTO_RESIZE_THRESHOLD_HEIGHT
            || currentWidth <= CAPTIONS_AUTO_RESIZE_THRESHOLD_WIDTH;

        if (shouldResizeCaptions) {
            const smallestDimension = Math.min(currentHeight, currentWidth);
            const newFontSize = Math.round(smallestDimension * CAPTIONS_AUTO_RESIZE_SCALE);
            const newStyle = extend({}, currentCaption.style, {
                fontSize: newFontSize,
            });

            return extend({}, currentCaption, {
                style: newStyle,
            });
        }

        return currentCaption;
    default:
        return currentCaption;
    }
}
