import assign from 'lodash/assign';
import includes from 'lodash/includes';
import { ACTION_SET_DEVICE_NAME, ACTION_SET_CASTING_STATE } from '../actions/chromecast';

export const UNAVAILABLE = 'unavailable';
export const AVAILABLE = 'available';
export const CONNECTING = 'connecting';
export const CONNECTED = 'connected';

export const VALID_CASTING_STATES = Object.freeze([
    UNAVAILABLE,
    AVAILABLE,
    CONNECTING,
    CONNECTED,
]);

const DEFAULT_CHROMECAST = {
    deviceName: '',
    castingState: UNAVAILABLE,
};

/**
 * Store reducer for Chromecast state.
 *
 * @param {?Object} chromecast
 * @param {Action} action
 * @return {Object}
 */
export function chromecast(currentState = DEFAULT_CHROMECAST, action) {
    switch (action.type) {
    case ACTION_SET_DEVICE_NAME:
        return assign({}, currentState, {
            deviceName: action.deviceName,
        });
    case ACTION_SET_CASTING_STATE:
        if (!includes(VALID_CASTING_STATES, action.castingState)) {
            return currentState;
        }
        return assign({}, currentState, {
            castingState: action.castingState,
        });
    default:
        return currentState;
    }
}
