import assign from 'lodash/assign';
import { ACTION_CLIP_RECOMMENDATIONS_LOADED } from 'actions/clip-recommendations';
import { addIfNotPresent } from 'ui/player-types/clips/utils/state-helper';

export const DEFAULT_CLIPS_DATA = Object.freeze({
    bySlug: {}, // clip slugs => {} associated clip data
    allSlugs: [], // all clip slugs
});

/**
 * Store reducer for clips.
 *
 * @param {Object} currentState
 * @param {Action} action
 * @return {Object}
 */
export function clipsData(currentState = DEFAULT_CLIPS_DATA, action) {
    switch (action.type) {
    case ACTION_CLIP_RECOMMENDATIONS_LOADED: {
        const newState = assign({}, currentState);

        Object.keys(action.recommendationSets).forEach(clipsSetKey => {
            action.recommendationSets[clipsSetKey].forEach(clip => {
                newState.bySlug[clip.slug] = clip;
                newState.allSlugs = addIfNotPresent(newState.allSlugs, clip.slug);
            });
        });

        return newState;
    }
    default:
        return currentState;
    }
}
