import { ACTION_CLOSE_COLLECTION_SIDEBAR, ACTION_OPEN_COLLECTION_SIDEBAR,
         ACTION_REQUEST_COLLECTION, ACTION_SET_COLLECTION, ACTION_CLEAR_COLLECTION,
         ACTION_FETCHED_FEATURED_COLLECTION } from '../actions/collection';
import { ACTION_SET_STREAM } from '../actions/stream';
import merge from 'lodash/merge';

// state when the sidebar is closed and title is displayed
export const COLLAPSED_VIEW = 'collapsed';
// state when the sidebar is open and items are displayed
export const SIDEBAR_VIEW = 'sidebar';
// state when no collection playing
export const NO_COLLECTION_VIEW = 'none';

const DEFAULT_FEATURED_COLLECTION = {
    id: '',
    itemsCount: 0,
    owner: {
        displayName: '',
        id: '',
        name: '',
    },
    thumbnails: {
        large: 'https://static-cdn.jtvnw.net/jtv_user_pictures/xarth/404_user_70x70.png',
        medium: 'https://static-cdn.jtvnw.net/jtv_user_pictures/xarth/404_user_70x70.png',
        small: 'https://static-cdn.jtvnw.net/jtv_user_pictures/xarth/404_user_70x70.png',
        template: 'https://static-cdn.jtvnw.net/jtv_user_pictures/xarth/404_user_70x70.png',
    },
    title: '',
};

const DEFAULT_COLLECTION = {
    id: '',
    owner: {
        displayName: '',
        id: '',
        name: '',
    },
    thumbnails: {
        large: 'https://static-cdn.jtvnw.net/jtv_user_pictures/xarth/404_user_70x70.png',
        medium: 'https://static-cdn.jtvnw.net/jtv_user_pictures/xarth/404_user_70x70.png',
        small: 'https://static-cdn.jtvnw.net/jtv_user_pictures/xarth/404_user_70x70.png',
        template: 'https://static-cdn.jtvnw.net/jtv_user_pictures/xarth/404_user_70x70.png',
    },
    title: '',
    totalDuration: 0,
    views: 0,
    items: [],
    currentView: NO_COLLECTION_VIEW,
    pendingRequest: {
        collectionId: '',
        videoId: '',
        timestamp: '',
        preferVideo: false,
    },
    featuredCollection: DEFAULT_FEATURED_COLLECTION,
};

/**
 * Store reducer for collections
 *
 * @param {Object} collections
 * @param {Action} action
 * @return {Object}
 */
export function collection(collection = DEFAULT_COLLECTION, action) {
    switch (action.type) {
    case ACTION_REQUEST_COLLECTION:
        return merge({}, collection, { pendingRequest: action.request });
    case ACTION_FETCHED_FEATURED_COLLECTION:
        return merge({}, collection, {
            featuredCollection: merge({}, DEFAULT_FEATURED_COLLECTION, action.featuredCollection),
        });
    case ACTION_SET_COLLECTION:
        return merge({}, DEFAULT_COLLECTION, action.collection, {
            pendingRequest: {
                collectionId: '',
                videoId: '',
                timestamp: '',
                preferVideo: false,
            },
            currentView: COLLAPSED_VIEW,
        });
    case ACTION_CLEAR_COLLECTION:
        return DEFAULT_COLLECTION;
    case ACTION_OPEN_COLLECTION_SIDEBAR:
        return merge({}, collection, {
            currentView: SIDEBAR_VIEW,
        });
    case ACTION_CLOSE_COLLECTION_SIDEBAR:
        return merge({}, collection, {
            currentView: COLLAPSED_VIEW,
        });
    case ACTION_SET_STREAM:
        return merge({}, collection, {
            pendingRequest: {
                collectionId: '',
                videoId: '',
                timestamp: '',
                preferVideo: false,
            },
            featuredCollection: DEFAULT_FEATURED_COLLECTION,
        });
    default:
        return collection;
    }
}
