import extend from 'lodash/extend';
import { ACTION_SET_COMMUNITIES_DATA } from '../actions/communities';

export const DEFAULT_COMMUNITIES = {
    /* eslint-disable camelcase */
    data: [{
        _id: '',
        owner_id: '',
        name: '',
        summary: '',
        description: '',
        rules: '',
    }],
    ids: '', // a comma separated string of id's
    /* eslint-enable camelcase */
};

export function communities(currentState = DEFAULT_COMMUNITIES, action) {
    switch (action.type) {
    case ACTION_SET_COMMUNITIES_DATA:
        return extend({}, currentState, {
            data: action.communities.data,
            ids: action.communities.ids,
        });
    default:
        return currentState;
    }
}
