import Comscore from '../../../vendor/streamsense.min.js';
import { ACTION_SET_STREAM } from '../actions/stream';
import { ACTION_RESET_TAG } from '../actions/comscore';

const COMSCORE_CLIENT_ID = '6745306'; // Twitch
const DEFAULT_STATE = {
    streamingTag: new Comscore.StreamingTag({
        customerC2: COMSCORE_CLIENT_ID,
    }),
};

/**
 * Store reducer for Comscore data
 *
 * @param {Object} state
 * @param {Action} action
 * @return {Object}
 */
export function comscore(state = DEFAULT_STATE, action) {
    switch (action.type) {
    case ACTION_SET_STREAM:
    case ACTION_RESET_TAG:
        // Stop current tag and instantiate new when content changes or ended content is replayed
        state.streamingTag.stop();
        return {
            streamingTag: new Comscore.StreamingTag({
                customerC2: COMSCORE_CLIENT_ID,
            }),
        };
    default:
        return state;
    }
}
