import { ACTION_ERROR, ACTION_CLEAR_ERROR } from '../actions/error';

/**
 * Store reducer for stream error status.
 *
 * @param {Error} error
 * @param {Action} action
 * @return {Error}
 */

const NULL_ERROR = {
    hasError: false,
    code: -1,
};

export function error(error = NULL_ERROR, action) {
    switch (action.type) {
    case ACTION_ERROR:
        return {
            hasError: true,
            code: action.code,
        };
    case ACTION_CLEAR_ERROR:
        return NULL_ERROR;
    default:
        return error;
    }
}
