import { ACTION_SET_EXPERIMENTS } from '../actions/experiments';

const ERROR_UNCONFIGURED_EXPERIMENT_CLIENT = new Error('Attempting to use experiments too early');
const DEFAULT_CLIENT = {
    get() {
        return Promise.reject(ERROR_UNCONFIGURED_EXPERIMENT_CLIENT);
    },
};

/**
 * Store reducer for experiments.
 *
 * @param {Minixperiment.Client} experiments
 * @param {Action} action
 * @return {Minixperiment.Client}
 */
export function experiments(client = DEFAULT_CLIENT, action) {
    switch (action.type) {
    case ACTION_SET_EXPERIMENTS:
        return action.experiments;
    default:
        return client;
    }
}
