import assign from 'lodash/assign';
import pick from 'lodash/pick';
import { ACTION_FOLLOW_INFO_FETCHED, ACTION_SHOW_FOLLOW_NOTIFICATION } from '../actions/follow';
import { ACTION_SET_STREAM } from '../actions/stream';

const DEFAULT_CHANNEL_RELATIONSHIPS = {
    fetched: false,
    following: false,
    notificationsEnabled: false,
    showFollowNotification: false,
};

/**
 * Houses follow state for the channels a user visits.
 *
 * @param {Object} channelState
 * @param {Object} action
 * @return {Object} newState
 */
export function follow(channelState = DEFAULT_CHANNEL_RELATIONSHIPS, action) {
    switch (action.type) {
    case ACTION_SHOW_FOLLOW_NOTIFICATION:
        return assign({}, channelState, {
            showFollowNotification: action.show,
        });
    case ACTION_FOLLOW_INFO_FETCHED:
        return assign({}, channelState, {
            fetched: true,
        }, pick(action.followInfo, Object.keys(DEFAULT_CHANNEL_RELATIONSHIPS)));
    case ACTION_SET_STREAM:
        return DEFAULT_CHANNEL_RELATIONSHIPS;
    default:
        return channelState;
    }
}
