import { applyMiddleware, compose, combineReducers,
         createStore } from 'redux';
import thunk from 'redux-thunk';
import { accessToken } from './access-token';
import { ads } from './ads';
import { adsManager } from './ads-manager';
import { analytics } from './analytics';
import { analyticsTracker } from './analytics-tracker';
import { backend } from './backend';
import { backendInfo } from './backend-info';
import { broadcasterInfo } from './broadcaster-info';
import { captions } from './captions';
import { clipRecommendations } from './clip-recommendations';
import { clipsData } from './clips-data';
import { clips } from './clips';
import { communities } from './communities';
import { comscore } from './comscore';
import { chromecast } from './chromecast';
import { env } from './env';
import { experiments } from './experiments';
import { extensions } from './extensions';
import { lang } from './lang';
import { manifestInfo } from './manifest-info';
import { notifications } from './notifications';
import { online } from './online';
import { collection } from './collection';
import { playerDimensions } from './player-dimensions';
import { playerOptions } from './player-options';
import { error } from './error';
import { follow } from './follow';
import { playback } from './playback';
import { quality } from './quality';
import { recommendations } from './recommendations';
import { resumeWatch } from './resume-watch';
import { screen } from './screen';
import { screenMode } from './screen-mode';
import { stats } from './stats';
import { stream } from './stream';
import { streamMetadata } from './stream-metadata';
import { subscriptions } from './subscriptions';
import { timelineMetadata } from './timeline-metadata';
import { tracking } from './tracking';
import { ui } from './ui';
import { user } from './user';
import { usher } from './usher';
import { viewercount } from './viewercount';
import { watchParty } from './watch-party';
import { windowReducer } from './window';
import { settings } from './settings';
import { onlineStatus } from './online-status';
import { ACTION_SET_WINDOW } from '../actions/window';
import { ACTION_LIVESTREAM_SET_RESUME_TIME, ACTION_VOD_SET_RESUME_TIME } from '../actions/resume-watch';
import { createVideoApiMiddleware } from '../middleware/video-api-middleware';
import { createEventEmitterMiddleware } from 'middleware/event-emitter-middleware';
import { createEmbedHostMiddleware } from 'middleware/embed-host-middleware';
import { createAnalyticsTrackerMiddleware } from 'middleware/analytics-tracker-middleware';
import { createUIMiddleware } from 'middleware/ui-middleware';

const rootReducer = combineReducers({
    accessToken,
    ads,
    adsManager,
    analytics,
    analyticsTracker,
    backend,
    backendInfo,
    broadcasterInfo,
    captions,
    chromecast,
    clipRecommendations,
    clips,
    clipsData,
    collection,
    communities,
    comscore,
    env,
    error,
    experiments,
    extensions,
    follow,
    lang,
    manifestInfo,
    notifications,
    online,
    onlineStatus,
    playback,
    playerDimensions,
    playerOptions,
    quality,
    recommendations,
    resumeWatch,
    screen,
    screenMode,
    settings,
    stats,
    stream,
    streamMetadata,
    subscriptions,
    timelineMetadata,
    tracking,
    ui,
    user,
    usher,
    viewercount,
    watchParty,
    window: windowReducer,
});

/**
 * Initializes the store for a given instance of the player.
 *
 * @return {Redux.Store}
 */
export function init(preloadedState = {}) {
    return createStore(
        rootReducer,
        preloadedState,
        compose(
            applyMiddleware(thunk, createVideoApiMiddleware()),
            applyMiddleware(thunk, createEventEmitterMiddleware()),
            applyMiddleware(thunk, createEmbedHostMiddleware()),
            applyMiddleware(thunk, createAnalyticsTrackerMiddleware()),
            applyMiddleware(thunk, createUIMiddleware()),
            // eslint-disable-next-line no-undef
            (window.devToolsExtension && process.env.NODE_ENV === 'development'
                ? window.devToolsExtension({
                    serialize: {
                        replacer: (key, value) => {
                            switch (key) {
                            case 'adsManager':
                                return `[object ${value.constructor.name}]`;
                            case 'window':
                                return '[object Window]';
                            default:
                                return value;
                            }
                        },
                    },
                    actionsBlacklist: [
                        ACTION_SET_WINDOW,
                        ACTION_LIVESTREAM_SET_RESUME_TIME,
                        ACTION_VOD_SET_RESUME_TIME,
                    ],
                })
                : f => f
            )
        )
    );
}
