import { ACTION_SET_LANGUAGE } from '../actions/lang';
import { DEFAULT_LANGUAGE } from '../lang/i18n';

/**
 * Store reducer for selected language translations.
 *
 * @param {?I18n} lang
 * @param {Action} action
 * @return {I18n}
 */
export function lang(lang = DEFAULT_LANGUAGE, action) {
    switch (action.type) {
    case ACTION_SET_LANGUAGE:
        return action.lang;
    default:
        return lang;
    }
}
