import { ACTION_SET_MANIFEST_INFO } from '../actions/manifest-info';
import { ACTION_SET_STREAM } from '../actions/stream';
import assign from 'lodash/assign';
import pick from 'lodash/pick';

export const DEFAULT_MANIFEST_INFO = {
    /* eslint-disable camelcase */
    abs: false,
    broadcast_id: 0,
    cluster: '',
    future: false,
    manifest_cluster: '',
    manifest_node: '',
    manifest_node_type: '',
    node: '',
    origin: '',
    region: '',
    segment_protocol: '',
    server_time: 0,
    serving_id: '',
    stream_time: 0,
    user_ip: '',
    suppress: false,
    transcodestack: 'not listed',
    /* eslint-enable camelcase */
};

/**
 * Store reducer for info from the master manifest
 *
 * @param {Object} manifestInfo
 * @param {Action} action
 * @return {Object}
 */
export function manifestInfo(manifestInfo = DEFAULT_MANIFEST_INFO, action) {
    switch (action.type) {
    case ACTION_SET_STREAM:
        return DEFAULT_MANIFEST_INFO;
    case ACTION_SET_MANIFEST_INFO:
        return assign({}, manifestInfo, pick(action.info, Object.keys(DEFAULT_MANIFEST_INFO)), {
            // eslint-disable-next-line camelcase
            stream_time: parseFloat(action.info.stream_time, 10) || 0,
        });
    default:
        return manifestInfo;
    }
}
