import concat from 'lodash/concat';
import slice from 'lodash/slice';
import { ACTION_ADD_NOTIFICATION, ACTION_REMOVE_NOTIFICATION } from '../actions/notifications';

const DEFAULT_NOTIFICATIONS = [];

/**
 * Store reducer for notifications.
 *
 * @param {Array} notifications
 * @param {Action} action
 * @return {Array}
 */
export function notifications(notifications = DEFAULT_NOTIFICATIONS, action) {
    switch (action.type) {
    case ACTION_ADD_NOTIFICATION:
        return concat(action.notification, notifications);
    case ACTION_REMOVE_NOTIFICATION:
        return slice(notifications, 1);
    default:
        return notifications;
    }
}
