import { ACTION_SET_STREAM } from '../actions/stream';
import { ACTION_SET_ONLINE } from '../actions/online';
import { ACTION_SET_STREAMMETADATA } from '../actions/stream-metadata';

export const ONLINE_STATUS = 'online';
export const OFFLINE_STATUS = 'offline';
export const UNKNOWN_STATUS = 'unknown';

/**
 * Store reducer for stream online status.
 *
 * @param {String} Online Status
 * @param {Action} action
 * @return {String}
 */

export function onlineStatus(currentOnlineStatus = UNKNOWN_STATUS, action) {
    switch (action.type) {
    case ACTION_SET_ONLINE:
        return action.online ? ONLINE_STATUS : OFFLINE_STATUS;
    case ACTION_SET_STREAM:
        return UNKNOWN_STATUS;
    case ACTION_SET_STREAMMETADATA:
        return action.streamMetadata.type === 'live' ? ONLINE_STATUS : currentOnlineStatus;
    default:
        return currentOnlineStatus;
    }
}
