import { ACTION_SET_STREAMMETADATA } from '../actions/stream-metadata';
import { ACTION_SET_ONLINE } from '../actions/online';

/**
 * Store reducer for stream online status.
 *
 * @param {Boolean} Online Status
 * @param {Action} action
 * @return {Boolean}
 */
export function online(online = false, action) {
    switch (action.type) {
    case ACTION_SET_STREAMMETADATA:
        return action.streamMetadata.type === 'live' ? true : online;
    case ACTION_SET_ONLINE:
        return action.online;
    default:
        return online;
    }
}
