import assign from 'lodash/assign';
import { ACTION_UPDATE_PLAYER_DIMENSIONS } from '../actions/player-dimensions';

const DEFAULT_PLAYER_DIMENSIONS = {
    left: 0,
    top: 0,
    width: 0,
    height: 0,
};

/**
 * Store reducer for player dimensions.
 *
 * @param {Object} playerDimensions
 * @param {Action} action
 * @return {Object}
 */
export function playerDimensions(playerDimensions = DEFAULT_PLAYER_DIMENSIONS, action) {
    switch (action.type) {
    case ACTION_UPDATE_PLAYER_DIMENSIONS:
        return assign({}, playerDimensions, action.playerDimensions);
    default:
        return playerDimensions;
    }
}
