import merge from 'lodash/merge';
import { ACTION_SET_PROVIDED_OPTIONS } from '../actions/player-options';

export const DEFAULT_PROVIDED_OPTIONS = {
    branding: true,
    showInfo: true,
    showtheatre: false,
    collection: '',
    channel: '',
    channelId: '',
    video: '',
    // eslint-disable-next-line camelcase
    tt_content: '',
    // eslint-disable-next-line camelcase
    tt_medium: '',
};

/**
 * Store reducer for options passed in to create the video object
 *
 * @param {Object} options
 * @param {Action} action
 * @return {Object}
 */
export function playerOptions(playerOptions = DEFAULT_PROVIDED_OPTIONS, action) {
    switch (action.type) {
    case ACTION_SET_PROVIDED_OPTIONS:
        return merge({}, playerOptions, action.playerOptions);
    default:
        return playerOptions;
    }
}
