import assign from 'lodash/assign';
import { ACTION_SELECT_QUALITY, ACTION_SET_CURRENT_QUALITY, ACTION_SET_QUALITIES,
         DEFAULT_STREAM_FORMAT, DEFAULT_STREAM_BITRATE_IN_BPS, ACTION_SET_ABS_AVAILABILITY } from '../actions/quality';

const DEFAULT_QUALITY = {
    absAvailable: false,
    current: '',
    selected: DEFAULT_STREAM_FORMAT,
    bitrate: DEFAULT_STREAM_BITRATE_IN_BPS,
    available: [],
};

/**
 * Store reducer for quality data.
 *
 * @param {?Object} state
 * @param {Action} action
 * @return {Object}
 */
export function quality(state = DEFAULT_QUALITY, action) {
    switch (action.type) {
    case ACTION_SELECT_QUALITY:
        return assign({}, state, {
            selected: action.quality,
            bitrate: action.bitrate,
        });
    case ACTION_SET_CURRENT_QUALITY:
        return assign({}, state, {
            current: action.quality,
        });
    case ACTION_SET_QUALITIES:
        return assign({}, state, {
            available: action.qualities,
        });
    case ACTION_SET_ABS_AVAILABILITY:
        return assign({}, state, {
            absAvailable: action.absAvailable,
        });
    default:
        return state;
    }
}
