import { ACTION_SET_RECOMMENDED_VODS, ACTION_CLEAR_RECOMMENDED_VODS, ACTION_SET_NUM_VODS_VISIBLE,
         ACTION_SET_FETCHING_STATUS, UNFETCHED, FETCHED } from 'actions/recommendations.js';
import { ACTION_SET_STREAM } from 'actions/stream.js';
import assign from 'lodash/assign';

const DEFAULT_RECOMMENDATIONS = {
    type: '',
    videos: [],
    numVideosVisible: 0,
    status: UNFETCHED,
};

/**
 * Store reducer for recommended VODs.
 *
 * @param {Array<Object>} currentRecommendations Current recommended VODs.
 * @param {Action} action
 * @return {Object} (possibly new) recommended VODs
 */
export function recommendations(currentRecommendations = DEFAULT_RECOMMENDATIONS, action) {
    switch (action.type) {
    case ACTION_SET_RECOMMENDED_VODS:
        return assign({}, currentRecommendations, {
            type: action.recommendationsType,
            videos: action.videos,
            status: FETCHED,
            numVideosVisible: (action.videos.length > 0 ? currentRecommendations.numVideosVisible : 0),
        });
    case ACTION_SET_FETCHING_STATUS:
        return assign({}, currentRecommendations, { status: action.status });
    case ACTION_SET_NUM_VODS_VISIBLE:
        return assign({}, currentRecommendations, { numVideosVisible: action.numVids });
    case ACTION_CLEAR_RECOMMENDED_VODS:
    case ACTION_SET_STREAM:
        return assign({}, DEFAULT_RECOMMENDATIONS);
    default:
        return currentRecommendations;
    }
}
