import assign from 'lodash/assign';
import { ACTION_SET_FULLSCREEN, ACTION_SET_CAN_FULLSCREEN, ACTION_TOGGLE_FULLSCREEN,
         ACTION_SET_THEATRE_MODE, ACTION_TOGGLE_THEATRE_MODE } from '../actions/screen-mode';
import { ACTION_SET_PROVIDED_OPTIONS } from '../actions/player-options';

export const DEFAULT_SCREEN_MODE = Object.freeze({
    isFullScreen: false,
    canFullScreen: false,
    canTheatreMode: false,
    isTheatreMode: false,
});

/**
 * Store reducer for fullscreen functionality
 *
 * @param {Object} backend
 * @param {Action} action
 * @return {Object}
 */
export function screenMode(screenMode = DEFAULT_SCREEN_MODE, action) {
    switch (action.type) {
    case ACTION_SET_FULLSCREEN:
        return assign({}, screenMode, {
            isFullScreen: action.isFullScreen,
        });
    case ACTION_TOGGLE_FULLSCREEN:
        if (screenMode.canFullScreen) {
            return assign({}, screenMode, {
                isFullScreen: !screenMode.isFullScreen,
            });
        }
        return screenMode;
    case ACTION_SET_CAN_FULLSCREEN:
        return assign({}, screenMode, {
            canFullScreen: action.canFullScreen,
        });
    case ACTION_SET_PROVIDED_OPTIONS:
        return assign({}, screenMode, {
            canTheatreMode: action.playerOptions.showtheatre,
        });
    case ACTION_SET_THEATRE_MODE:
        return assign({}, screenMode, {
            isTheatreMode: action.isTheatreMode,
        });
    case ACTION_TOGGLE_THEATRE_MODE:
        if (screenMode.canTheatreMode) {
            return assign({}, screenMode, {
                isTheatreMode: !screenMode.isTheatreMode,
            });
        }
        return screenMode;
    default:
        return screenMode;
    }
}
