import includes from 'lodash/includes';
import { ACTION_PUSH_SCREEN, ACTION_POP_SCREEN, CONTENT_SCREEN,
         VOD_RECOMMENDATION_SCREEN, VOD_RESTRICTED_SCREEN, ADVERTISEMENT_SCREEN,
         STITCHED_ADVERTISEMENT_SCREEN, ERROR_SCREEN, COLLECTION_EMPTY_SCREEN,
         QUALITY_RESTRICTED_SCREEN } from '../actions/screen';
import { ACTION_SET_STREAM } from '../actions/stream';
import { ACTION_ERROR, ACTION_CLEAR_ERROR } from '../actions/error';
import { ACTION_SET_AD_METADATA, AdContentTypes } from '../actions/ads';

/**
 * Store reducer for screen switch.
 *
 * @param {Array<String>} screenStack
 * @param {Action} action
 * @return {Array<String>}
 */
// eslint-disable-next-line complexity
export function screen(screenStack = [CONTENT_SCREEN], action) {
    switch (action.type) {
    case ACTION_SET_AD_METADATA:
        switch (action.currentMetadata.contentType) {
        case AdContentTypes.IMA:
            if (screenStack[0] !== ADVERTISEMENT_SCREEN) {
                return [ADVERTISEMENT_SCREEN].concat(screenStack);
            }
            return screenStack;
        case AdContentTypes.STITCHED:
            if (screenStack[0] !== STITCHED_ADVERTISEMENT_SCREEN) {
                return [STITCHED_ADVERTISEMENT_SCREEN].concat(screenStack);
            }
            return screenStack;
        case AdContentTypes.NONE:
            if (includes([ADVERTISEMENT_SCREEN, STITCHED_ADVERTISEMENT_SCREEN], screenStack[0])) {
                return screenStack.slice(1);
            }
            return screenStack;
        default:
            return screenStack;
        }
    case ACTION_PUSH_SCREEN:
        return [action.screen].concat(screenStack);
    case ACTION_POP_SCREEN:
        if (screenStack.length === 1) {
            return [CONTENT_SCREEN];
        }
        return screenStack.slice(1);
    case ACTION_SET_STREAM:
        if (includes([VOD_RECOMMENDATION_SCREEN, VOD_RESTRICTED_SCREEN, COLLECTION_EMPTY_SCREEN], screenStack[0])) {
            return screenStack.slice(1);
        }
        return screenStack;
    case ACTION_ERROR:
        // Don't push error screen if these screens are already on top of the stack
        if (!includes([ERROR_SCREEN, VOD_RESTRICTED_SCREEN, QUALITY_RESTRICTED_SCREEN], screenStack[0])) {
            return [ERROR_SCREEN].concat(screenStack);
        }
        return screenStack;
    case ACTION_CLEAR_ERROR:
        if (screenStack[0] === ERROR_SCREEN) {
            return screenStack.slice(1);
        }
        return screenStack;
    default:
        return screenStack;
    }
}
