import assign from 'lodash/assign';
import pick from 'lodash/pick';
import * as SettingsActions from '../actions/settings';

const DEFAULT_SETTINGS_STATE = {
    persistenceEnabled: true,
};

const SETTINGS_KEYS = Object.keys(DEFAULT_SETTINGS_STATE);

/**
 * Store reducer for settings state
 *
 * @param {?Object} settingsState
 * @param {Action} action
 * @return {Object}
 */

export function settings(settingsState = DEFAULT_SETTINGS_STATE, action) {
    switch (action.type) {
    case SettingsActions.ACTION_INITIALIZE_SETTINGS:
        return assign({}, settingsState, pick(action.settings, SETTINGS_KEYS));
    case SettingsActions.ACTION_SET_PERSISTENCE:
        return assign({}, settingsState, {
            persistenceEnabled: Boolean(action.value),
        });
    default:
        return settingsState;
    }
}
