import { ACTION_UPDATE_STATS, ACTION_DISPLAY_STATS } from '../actions/stats';
import pick from 'lodash/pick';
import assign from 'lodash/assign';

/**
 * Store reducer playback statistics
 *
 * @param {Object} stats
 * @param {Action} action
 * @return {Boolean}
 */

export const DEFAULT_STATS = {
    videoStats: {
        bufferSize: 0,
        displayResolution: '',
        skippedFrames: 0,
        fps: 0,
        bitrate: 0,
        hlsLatencyBroadcaster: 0,
        hlsLatencyEncoder: 0,
        memoryUsage: '',
        playbackRate: 0,
        videoResolution: '',
        backendVersion: '',
    },
    displayed: false,
};

export function stats(stats = DEFAULT_STATS, action) {
    switch (action.type) {
    case ACTION_UPDATE_STATS:
        return assign({}, stats, {
            videoStats: pick(action.videoStats, Object.keys(DEFAULT_STATS.videoStats)),
        });
    case ACTION_DISPLAY_STATS:
        return assign({}, stats, {
            displayed: action.displayed,
        });
    default:
        return stats;
    }
}
