import { ACTION_SET_STREAMMETADATA, VIEWERS_NOT_SET } from '../actions/stream-metadata';
import { ACTION_SET_STREAM } from '../actions/stream';
import { CONTENT_MODE_LIVE } from '../stream/twitch-live';
import { CONTENT_MODE_VOD } from '../stream/twitch-vod';
import { CONTENT_MODE_PROVIDED } from '../stream/provided';
import merge from 'lodash/merge';
import assign from 'lodash/assign';

export const TYPE_DEAD_LTV = 'dead_ltv';
export const TYPE_WATCH_PARTY = 'watch_party';

const DEFAULT_STREAM_METADATA = Object.freeze({
    broadcastID: 0,
    type: '',
    channelName: null, // ids are type String | Null
    videoId: null, // ids are type String | Null
    contentId: '',
    customerId: '',
    channel: {
        displayName: '',
        name: '',
        id: 0,
        partner: false,
        status: '',
        videoBanner: '',
        logo: '',
        mature: false,
    },
    createdAt: '',
    game: '',
    preview: {
        template: '',
    },
    streamType: '',
    url: '',
    viewers: VIEWERS_NOT_SET,
});

/**
 * Store reducer for channel information.
 *
 * @param {Object} currentStreamMetadata Current streamMetadata state.
 * @param {Action} action
 * @return {Object}
 */
export function streamMetadata(currentStreamMetadata = DEFAULT_STREAM_METADATA, action) {
    switch (action.type) {
    case ACTION_SET_STREAMMETADATA:
        return merge({}, currentStreamMetadata, action.streamMetadata);
    case ACTION_SET_STREAM:
        return assign({}, DEFAULT_STREAM_METADATA, {
            channelName: action.stream.contentType === CONTENT_MODE_LIVE ? action.stream.channel : null,
            videoId: action.stream.contentType === CONTENT_MODE_VOD ? action.stream.videoId : null,
            contentId: action.stream.contentType === CONTENT_MODE_PROVIDED ? action.stream.contentId : '',
            customerId: action.stream.contentType === CONTENT_MODE_PROVIDED ? action.stream.customerId : '',
        });
    default:
        return currentStreamMetadata;
    }
}
