import { ACTION_SET_STREAM } from '../actions/stream';
import { nullContentStream } from '../stream/null';

/**
 * Store reducer for streams.
 *
 * @param {ContentStream} currentStream
 * @param {Action} action
 * @return {ContentStream}
 */
export function stream(currentStream = nullContentStream, action) {
    switch (action.type) {
    case ACTION_SET_STREAM:
        return action.stream;
    default:
        return currentStream;
    }
}
