import assign from 'lodash/assign';
import {
    ACTION_SUBSCRIPTION_PRODUCTS_FETCHED,
    ACTION_CHANNEL_SUBSCRIPTIONS_FETCHED,
} from '../actions/subscriptions';
import { ACTION_SET_STREAM } from '../actions/stream';

const DEFAULT_SUBSCRIPTIONS = {
    isSubscribed: false,
    isSubscribable: false,
    didFetch: false,
};

/**
 * Sets subscription state for a channel and the current user.
 *
 * @param {Object} subscriptionState
 * @param {Object} action
 * @return {Object} newState
 */
export function subscriptions(subscriptionsState = DEFAULT_SUBSCRIPTIONS, action) {
    switch (action.type) {
    case ACTION_SUBSCRIPTION_PRODUCTS_FETCHED:
        return assign({}, subscriptionsState, action.subscriptions);
    case ACTION_CHANNEL_SUBSCRIPTIONS_FETCHED:
        return assign({}, subscriptionsState, { didFetch: true }, action.subscriptions);
    case ACTION_SET_STREAM:
        return DEFAULT_SUBSCRIPTIONS;
    default:
        return subscriptionsState;
    }
}
