import { ACTION_SET_MUTED_SEGMENTS, ACTION_SET_PREVIEWS, ACTION_SET_MARKERS } from '../actions/timeline-metadata';
import { ACTION_SET_STREAM } from '../actions/stream';
import assign from 'lodash/assign';

const DEFAULT_TIMELINE_METADATA = {
    mutedSegments: [],
    previews: {
        count: 0,
        lq: {
            width: 0,
            height: 0,
            rows: 0,
            cols: 0,
            URLs: [''],
        },
        hq: {
            width: 0,
            height: 0,
            rows: 0,
            cols: 0,
            URLs: [''],
        },
    },
    markers: [],
};

export function timelineMetadata(currentTimelineMetadata = DEFAULT_TIMELINE_METADATA, action) {
    switch (action.type) {
    case ACTION_SET_MUTED_SEGMENTS:
        return assign({}, currentTimelineMetadata, {
            mutedSegments: action.mutedSegments,
        });
    case ACTION_SET_PREVIEWS:
        return assign({}, currentTimelineMetadata, {
            previews: action.previews,
        });
    case ACTION_SET_MARKERS:
        return assign({}, currentTimelineMetadata, {
            markers: action.markers,
        });
    case ACTION_SET_STREAM:
        return DEFAULT_TIMELINE_METADATA;
    default:
        return currentTimelineMetadata;
    }
}
