import assign from 'lodash/assign';
import pick from 'lodash/pick';
import { ACTION_SET_TRACKING_PROPERTIES } from '../actions/tracking';

const WHITELISTED_PROPERTIES = [
    'app_session_id',
    'benchmark_session_id',
    'chat_visibility_status',
    'client_app',
    'content',
    'host_channel',
    'medium',
    'page_session_id',
    'player',
    'referrer',
    'referrer_url',
    'tab_session_id',
    'feed_impression_id',
];

export function tracking(properties = {}, action) {
    switch (action.type) {
    case ACTION_SET_TRACKING_PROPERTIES:
        return assign({}, properties, pick(action.properties, WHITELISTED_PROPERTIES));
    default:
        return properties;
    }
}
