import assign from 'lodash/assign';
import * as UIActions from '../actions/ui';
import { EXTENSION_MENU_MAIN } from 'util/extensions';

const DEFAULT_UI_STATE = {
    isMini: false,
    showSettings: UIActions.MENU_STATE_NONE,
    showVolumeSlider: true,
    showExtensionsSubmenu: EXTENSION_MENU_MAIN,
    showUI: false,
    onUIElement: false,
};

/**
 * Store reducer for ui state
 *
 * @param {?Object} uiState
 * @param {Action} action
 * @return {Object}
 */
export function ui(uiState = DEFAULT_UI_STATE, action) {
    switch (action.type) {
    case UIActions.ACTION_SHOW_VOLUME_SLIDER:
        return assign({}, uiState, {
            showVolumeSlider: action.value,
        });
    case UIActions.ACTION_SET_MINIPLAYER_MODE:
        return assign({}, uiState, {
            isMini: Boolean(action.value),
        });
    case UIActions.ACTION_SHOW_SETTINGS_MENU:
        return assign({}, uiState, {
            showSettings: action.value,
            showExtensionsSubmenu: action.extensionsSubmenu,
        });
    case UIActions.ACTION_SET_UI_DISPLAY:
        return assign({}, uiState, {
            showUI: action.showUI,
        });
    case UIActions.ACTION_HOVERING_ON_UI_ELEMENT:
        return assign({}, uiState, {
            onUIElement: true,
        });
    case UIActions.ACTION_HOVERING_OFF_UI_ELEMENT:
        return assign({}, uiState, {
            onUIElement: false,
        });
    default:
        return uiState;
    }
}
