import assign from 'lodash/assign';
import { ACTION_USER_LOGGED_IN, ACTION_USER_NOT_LOGGED_IN } from 'actions/user';

export const UNKNOWN = 'unknown';
export const LOGGED_IN = 'logged in';
export const NOT_LOGGED_IN = 'not logged in';

const DEFAULT_USER_DATA = {
    loggedInStatus: UNKNOWN,
    id: 0,
    isStaff: false,
    name: '',
};

/**
 * Store reducer for user state.
 *
 * @param {?Object} user
 * @param {Action} action
 * @return {Object}
 */

export function user(user = DEFAULT_USER_DATA, action) {
    switch (action.type) {
    case ACTION_USER_LOGGED_IN:
        return assign({}, action.userInfo, {
            loggedInStatus: LOGGED_IN,
        });
    case ACTION_USER_NOT_LOGGED_IN:
        return assign({}, DEFAULT_USER_DATA, {
            loggedInStatus: NOT_LOGGED_IN,
        });
    default:
        return user;
    }
}
