import assign from 'lodash/assign';
import { ACTION_SET_USHER_PARAMS, ACTION_SET_USHER_HOST_OVERRIDE } from '../actions/usher';

export const DEFAULT_USHER = Object.freeze({
    params: {},
    hostOverride: '',
});
/**
 * Store reducer for Usher parameters.
 *
 * @param {Object} parameters
 * @param {Action} action
 * @return {Object}
 */
export function usher(state = DEFAULT_USHER, action) {
    switch (action.type) {
    case ACTION_SET_USHER_PARAMS:
        return assign({}, state, {
            params: action.params,
        });
    case ACTION_SET_USHER_HOST_OVERRIDE:
        return assign({}, state, {
            hostOverride: action.hostOverride,
        });
    default:
        return state;
    }
}
