import { ACTION_SET_STREAMMETADATA } from '../actions/stream-metadata';
import { ACTION_UPDATE_VIEWERCOUNT } from '../actions/viewercount';

/**
 * Store reducer for viewercount.
 *
 * @param {Integer} count
 * @param {Action} action
 * @return {Integer}
 */
export function viewercount(count = 0, action) {
    switch (action.type) {
    case ACTION_SET_STREAMMETADATA:
        return action.streamMetadata.viewers || count;
    case ACTION_UPDATE_VIEWERCOUNT:
        return action.count;
    default:
        return count;
    }
}
