import assign from 'lodash/assign';
import { ACTION_SET_WATCHPARTY_VOD } from '../actions/watch-party';

export const DEFAULT_WATCHPARTY = Object.freeze({
    watchPartyId: '',
    vodId: '',
    title: '',
    viewable: '',
    broadcastType: '',
    incrementViewCountURL: '',
});

/**
 * Store reducer for watch-party.
 */
export function watchParty(currentWatchParty = DEFAULT_WATCHPARTY, action) {
    switch (action.type) {
    case ACTION_SET_WATCHPARTY_VOD:
        return assign({}, currentWatchParty, action.pubsubVodInfo);
    default:
        return currentWatchParty;
    }
}
