import { AbstractStream } from './stream';

export const CONTENT_MODE_CLIP = 'clip';

/**
 * Content stream class representing prerecorded clip content.
 */
export class ClipContentStream extends AbstractStream {
    /**
     * @param {String} slug
     *        ID associated with the clip (e.g. "UsuallyLooksLikeThisWithWeirdAdjectives")
     */
    constructor(slug) {
        super(...arguments);
        this._slug = slug;
    }

    /**
     * @return {String}
     */
    get contentType() {
        return CONTENT_MODE_CLIP;
    }

    /**
     * @return {String}
     */
    get slug() {
        return this._slug;
    }

    /**
     * streamUrls are not associated with a clip stream, their sources are relative to the selected quality
     *
     * @return {Promise}
     */
    get streamUrl() {
        return Promise.resolve('');
    }

    /**
     * castStreamUrls are not associated with a clip stream, their sources are relative to the selected quality
     *
     * @return {Promise}
     */
    get castStreamUrl() {
        return Promise.resolve('');
    }

    /**
     * not used in clips
     */
    get accessToken() {
        return Promise.resolve({});
    }
}
