export const CONTENT_MODE_NONE = null;

/**
 * Content stream class representing no current stream.
 */
class NullContentStream {
    constructor() {
    }

    /**
     * @return {?String}
     */
    get contentType() {
        return CONTENT_MODE_NONE;
    }

    /**
     * @return {String}
     */
    get channel() {
        return '';
    }

    /**
     * @return {Array<String>}
     */
    get restrictedBitrates() {
        return [];
    }

    /**
     * @return {String}
     */
    get videoId() {
        return '';
    }

    /**
     * @return {String}
     */
    get slug() {
        return '';
    }

    /**
     * @return {Promise<String>}
     */
    get streamUrl() {
        return Promise.resolve('');
    }

    /**
     * @return {Object}
     */
    get accessToken() {
        return Promise.resolve({});
    }
}

// Export a singleton; no point in `new`ing up any more than one of these.
export const nullContentStream = new NullContentStream();
