import { AbstractStream } from './stream';

export const CONTENT_MODE_VIDEO_SOURCE = 'video-source';

/**
 * Content stream class representing an video source
 */
export class VideoSourceContentStream extends AbstractStream {
    /**
     * @param {String} url
     *        url associated with the video source
     */
    constructor(url) {
        super(...arguments);
        this._url = url;
    }

    /**
     * @return {String}
     */
    get contentType() {
        return CONTENT_MODE_VIDEO_SOURCE;
    }

    /**
     * url of the video source, our implementation expects a promise to be returned.
     *
     * @return {Promise}
     */
    get streamUrl() {
        return Promise.resolve(this._url);
    }

    /**
     * url of the video source, our implementation expects a promise to be returned.
     *
     * @return {Promise}
     */
    get castStreamUrl() {
        return Promise.resolve(this._url);
    }

    /**
     * not used for video sources
     *
     * @return {Promise}
     */
    get accessToken() {
        return Promise.resolve({});
    }
}
