import { CONTENT_MODE_VOD } from 'stream/twitch-vod';
import { subscribe } from 'util/subscribe';
import { videoInfo, channelViewerInfo, isVODRestricted } from 'api';
import { pushScreen, VOD_RESTRICTED_SCREEN } from 'actions/screen';

// Shows an overlay for channels with paywalled VODs.
export class SubscribeOverlayManager {
    constructor(store) {
        this._store = store;
        subscribe(this._store, ['stream'], this.onStream.bind(this));
    }

    onStream() {
        const { stream } = this._store.getState();
        if (stream.contentType === CONTENT_MODE_VOD) {
            const vidInfo  = videoInfo(stream.videoId);
            const viewerInfo = vidInfo.then(info => channelViewerInfo(info.channel.name));
            Promise.all([vidInfo, viewerInfo]).then(([vidInfo, viewerInfo]) => {
                if (isVODRestricted(viewerInfo, vidInfo)) {
                    this._store.dispatch(pushScreen(VOD_RESTRICTED_SCREEN));
                }
            });
        }
    }

    destroy() { }
}
