import { subscribe } from './../util/subscribe';
import { CONTENT_MODE_VOD } from './../stream/twitch-vod';
import { setMutedSegments, setPreviews, setMarkers } from './../actions/timeline-metadata';
import { getMutedSegments } from './muted-segments';
import { getPreviews } from './thumbnail-previews';
import { getVODMarkers, TYPE_GAME_CHANGE } from './vod-markers';
import { getVCAMarkers, TYPE_GAME_METADATA } from './vca-markers';
import { MARKERS } from './../experiments';

export const MARKER_TYPE_GAME_CHANGE = TYPE_GAME_CHANGE;
export const MARKER_TYPE_GAME_METADATA = TYPE_GAME_METADATA;

export class TimelineMetadataManager {
    constructor(store) {
        this._store = store;
        this._subscribeStream(this._store.getState());
        this.unsub = subscribe(this._store, ['stream'], this._subscribeStream.bind(this));
    }

    _subscribeStream({ stream }) {
        const { experiments } = this._store.getState();

        if (stream.contentType !== CONTENT_MODE_VOD) {
            return;
        }

        getMutedSegments(stream.videoId).then(mutedSegments => {
            this._store.dispatch(setMutedSegments(mutedSegments));
        });

        getPreviews(stream.videoId).then(previews => {
            this._store.dispatch(setPreviews(previews));
        });

        experiments.get(MARKERS).then(markerExperimentResult => {
            switch (markerExperimentResult) {
            case 'vca':
                return getVCAMarkers(stream.videoId);
            case 'vod':
                return getVODMarkers(stream.videoId);
            }

            return [];
        }).then(markers => {
            this._store.dispatch(setMarkers(markers));
        });
    }

    destroy() {
        this.unsub();
    }
}
