import isFinite from 'lodash/isFinite';
import { videoInfo } from './../api';

export function getMutedSegments(videoID) {
    return videoInfo(videoID).
        then(info => normalizedMutedSegments(info.muted_segments));
}

function normalizedMutedSegments(segments = []) {
    if (segments === null) {
        return [];
    }

    if (segments.length <= 1) {
        return segments;
    }

    if (!isSegmentsFormatted(segments)) {
        return Promise.reject(new Error('Muted segments not formatted correctly'));
    }

    const sortedSegments = segments.slice(0).sort(function(a, b) {
        return a.offset - b.offset;
    });

    return combineOverlappingSegments(sortedSegments);
}

function isSegmentsFormatted(segments) {
    let isFormatted = true;

    segments.forEach(segment => {
        if (
            !segment.hasOwnProperty('offset') ||
            !segment.hasOwnProperty('duration') ||
            !isFinite(segment.offset) ||
            !isFinite(segment.duration)
        ) {
            isFormatted = false;
        }
    });

    return isFormatted;
}

function combineOverlappingSegments(segments) {
    return segments.reduce(function(resultArr, currentSegment) {
        const lastSegment = resultArr[resultArr.length - 1];
        const lastSegmentEnd = lastSegment.offset + lastSegment.duration;
        const currentSegmentEnd = currentSegment.offset + currentSegment.duration;

        if (lastSegmentEnd < currentSegment.offset) {
            resultArr.push(currentSegment);
        } else if (lastSegmentEnd < currentSegmentEnd) {
            lastSegment.duration = currentSegmentEnd - lastSegment.offset;
        }

        return resultArr;
    }, [segments[0]]);
}
