import { parseUri } from './../util/parseuri';
import { videoInfo } from './../api';

// Qualities of Thumbnail Previews
const LQ_PREVIEW = 'low';
const HQ_PREVIEW = 'high';

export function getPreviews(videoID) {
    return videoInfo(videoID).
        then(info => {
            return fetch(info.seek_previews_url).
                then(response => response.json()).
                then(data => normalizedPreviews(data, info.seek_previews_url));
        });
}

function normalizedPreviews(rawData, dataURL) {
    // Need to check for rawdata formatting
    if (rawData === null) {
        return Promise.reject(new Error('Raw preview data not available'));
    }

    const parsedURL = parseUri(dataURL);
    const directoryURL = `${parsedURL.protocol}://${parsedURL.host}${parsedURL.directory}`;
    const qualitiesIndex = {};
    rawData.forEach((preview, index) => {
        qualitiesIndex[preview.quality] = index;
    });
    const lqIndex = qualitiesIndex[LQ_PREVIEW];
    const hqIndex = qualitiesIndex[HQ_PREVIEW];

    return {
        count: rawData[lqIndex].count,
        lq: {
            width: rawData[lqIndex].width,
            height: rawData[lqIndex].height,
            rows: rawData[lqIndex].rows,
            cols: rawData[lqIndex].cols,
            URLs: rawData[lqIndex].images.map(url => `${directoryURL}${url}`),
        },
        hq: {
            width: rawData[hqIndex].width,
            height: rawData[hqIndex].height,
            rows: rawData[hqIndex].rows,
            cols: rawData[hqIndex].cols,
            URLs: rawData[hqIndex].images.map(url => `${directoryURL}${url}`),
        },
    };
}
