import { subscribe } from './util/subscribe';
import {
    fetchChannelSubscriptions,
    fetchSubscriptionProducts,
} from './actions/subscriptions';
import { fetchFollowInfo } from './actions/follow';
import { LOGGED_IN } from './state/user';

/**
 * Fetches data for the Twitch Everywhere panel.
 */
export class TwitchEverywhereManager {
    constructor(store) {
        this.store = store;
        this.unsubs = [];

        this.unsubs.push(subscribe(this.store, ['streamMetadata.channel'], this.onChannelChange.bind(this)));
    }

    onChannelChange() {
        const { user, streamMetadata } = this.store.getState();

        const channelName = streamMetadata.channel.name;

        this.store.dispatch(fetchSubscriptionProducts(channelName));

        if (user.loggedInStatus !== LOGGED_IN) {
            return;
        }

        const userId = user.id;
        const channelId = streamMetadata.channel.id;

        this.store.dispatch(fetchFollowInfo(userId, channelId));
        this.store.dispatch(fetchChannelSubscriptions(userId, channelId));
    }

    destroy() {
        this.unsubs.forEach(unsub => unsub());
    }
}
