import React from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';

const OFFLINE_BANNER = 'offline-banner';
const VIDEO_PREVIEW = 'video-preview';

const propTypes = {
    imgUrl: PropTypes.string.isRequired,
    bgType: PropTypes.string.isRequired,
};

export const BackgroundBanner = ({ imgUrl, bgType }) => {
    const CLASSES = classNames({
        'pl-background-banner': true,
        'pl-background-banner--offline': bgType === OFFLINE_BANNER,
        'pl-background-banner--preview': bgType === VIDEO_PREVIEW,
        'js-video-background-banner': true, // For QA
    });
    return (
        <div
            className={CLASSES}
            style={{ backgroundImage: `url(${imgUrl})` }}
        />
    );
};

BackgroundBanner.propTypes = propTypes;
