import React from 'react';
import PropTypes from 'prop-types';
import { NotificationPopUpsWrapper } from 'ui/containers/notifications-container';
import { Settings } from 'ui/containers/settings';
import { ExtensionSettings } from 'ui/containers/extension-settings';
import { ClosedCaptionButton } from 'ui/containers/buttons/closed-caption-button';
import { ClipsButton } from 'ui/containers/buttons/clips-button';
import { ChromecastButton } from 'ui/containers/buttons/chromecast-button';
import { TheatreModeButton } from 'ui/containers/buttons/theatre-mode-button';
import { FullScreenButton } from 'ui/containers/buttons/fullscreen-button';
import { WatchTwitchButton } from 'ui/containers/buttons/watch-twitch-button';
import { ShareButton } from 'ui/player-types/clips/buttons/share-button';
import { connect } from 'react-redux';
import { PLAYER_CLIPS_EMBED } from 'util/player-type';

export const CONTAINER_CLASSES = 'player-buttons-right';

const propTypes = {
    shouldShowShareButton: PropTypes.bool.isRequired,
};

const mapStateToProps = ({ env }) => ({
    shouldShowShareButton: PLAYER_CLIPS_EMBED === env.playerType,
});

export const BottomRightControlsComponent = ({ shouldShowShareButton }) => {
    return (
        <div className={CONTAINER_CLASSES}>
            <NotificationPopUpsWrapper />
            <Settings />
            <ExtensionSettings />
            <ClosedCaptionButton />
            <div className="player-menu">
                <ClipsButton />
            </div>
            {shouldShowShareButton && <ShareButton />}
            <ChromecastButton />
            <TheatreModeButton />
            <FullScreenButton />
            <WatchTwitchButton />
        </div>
    );
};

BottomRightControlsComponent.propTypes = propTypes;

export const BottomRightControls = connect(mapStateToProps)(BottomRightControlsComponent);
