import React from 'react';
import PropTypes from 'prop-types';

const propTypes = {
    className: PropTypes.string,
    children: PropTypes.oneOfType([
        PropTypes.arrayOf(PropTypes.element),
        PropTypes.element,
        PropTypes.node,
    ]),
    disabled: PropTypes.bool,
    id: PropTypes.string,
    onClick: PropTypes.func,
    onMouseOver: PropTypes.func,
    onMouseOut: PropTypes.func,
    onFocus: PropTypes.func,
    onBlur: PropTypes.func,
    tabIndex: PropTypes.string,
};

const defaultProps = {
    className: '',
    disabled: false,
    id: '',
    onClick() {},
    onMouseOver() {},
    onMouseOut() {},
    onFocus() {},
    onBlur() {},
    tabIndex: '0',
};

function createOnEnterKeyFn(onClick) {
    return function onKeyUp({ key }) {
        if (key === 'Enter') {
            onClick();
        }
    };
}

export function Button({
    children,
    className,
    disabled,
    id,
    onBlur,
    onClick,
    onFocus,
    onMouseOut,
    onMouseOver,
    tabIndex,
}) {
    return (
        <button
            className={className}
            disabled={disabled}
            id={id}
            onBlur={onBlur}
            onClick={onClick}
            onFocus={onFocus}
            onKeyUp={createOnEnterKeyFn(onClick)}
            onMouseOut={onMouseOut}
            onMouseOver={onMouseOver}
            tabIndex={tabIndex}
            type="button"
        >
            { children }
        </button>
    );
}

Button.propTypes = propTypes;
Button.defaultProps = defaultProps;
